//+------------------------------------------------------------------+
//|                                                        Basis.mqh |
//|                    Copyright 2023, Manuel Alejandro Cercos Perez |
//|                                  https://www.mql5.com/alexcercos |
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
class CElement
{
private:
   //Variable to generate names, but it's better to control that in the program
   static int        m_element_count;

   void              AddChild(CElement* child);

protected:
   //Chart object name
   string            m_name;

   //Element relations
   CElement*         m_parent;
   CElement*         m_children[];
   int               m_child_count;

   //Position and size
   int               m_x;
   int               m_y;
   int               m_size_x;
   int               m_size_y;

public:
   CElement();
   ~CElement();

   void              SetPosition(int x, int y);
   void              SetSize(int x, int y);
   void              SetParent(CElement* parent);

   int               GetGlobalX();
   int               GetGlobalY();

   void              CreateChildren();
   virtual void      Create() {}
};

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
class CProgram
{
protected:
   CElement          m_element_holder;

public:

   void              CreateGUI();
   void              AddMainElement(CElement* element);
};

int CElement::m_element_count = 0;

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
CElement::CElement(void) : m_child_count(0), m_x(0), m_y(0), m_size_x(100), m_size_y(100)
{
   m_name = "element_" + IntegerToString(m_element_count++);
}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
CElement::~CElement(void)
{
   for (int i = 0; i < m_child_count; i++)
      delete m_children[i];
}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CElement::SetSize(int x, int y)
{
   m_size_x = x;
   m_size_y = y;
}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CElement::SetPosition(int x, int y)
{
   m_x = x;
   m_y = y;
}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CElement::SetParent(CElement *parent)
{
   m_parent = parent;
   parent.AddChild(GetPointer(this));
}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CElement::AddChild(CElement *child)
{
   if (CheckPointer(child) == POINTER_INVALID)
      return;

   ArrayResize(m_children, m_child_count + 1);
   m_children[m_child_count] = child;
   m_child_count++;
}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int CElement::GetGlobalX(void)
{
   if (CheckPointer(m_parent) == POINTER_INVALID)
      return m_x;

   return m_x + m_parent.GetGlobalX();
}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int CElement::GetGlobalY(void)
{
   if (CheckPointer(m_parent) == POINTER_INVALID)
      return m_y;

   return m_y + m_parent.GetGlobalY();
}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CElement::CreateChildren(void)
{
   for (int i = 0; i < m_child_count; i++)
   {
      m_children[i].Create();
      m_children[i].CreateChildren();
   }
}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CProgram::CreateGUI(void)
{
   m_element_holder.CreateChildren();
}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CProgram::AddMainElement(CElement *element)
{
   element.SetParent(GetPointer(m_element_holder));
}
//+------------------------------------------------------------------+
